IF NOT EXISTS (SELECT * FROM sysobjects WHERE Name='Clientes_Reten_Exclusiones' AND xtype='U')
BEGIN
	CREATE TABLE Clientes_Reten_Exclusiones 
	(
		Id_Cli_Reten_Exclu			INT IDENTITY(1,1),
		Id_Cliente					INT,
		Id_Tipo_Reten				VARCHAR(10),
		Fecha_Desde					DATETIME,
		Fecha_Hasta					DATETIME,
		Nota						TEXT
	)
END
GO

ALTER TABLE Clientes_Reten_Exclusiones ADD CONSTRAINT PK_CRE_PorId PRIMARY KEY CLUSTERED (Id_Cli_Reten_Exclu)	
GO

CREATE INDEX IX_CRE_PorCli ON Clientes_Reten_Exclusiones (Id_Cliente,Id_Tipo_Reten)
GO

CREATE INDEX IX_CRE_PorRet ON Clientes_Reten_Exclusiones (Id_Tipo_Reten,Id_Cliente)
GO

ALTER TABLE Clientes_Reten_Exclusiones ADD CONSTRAINT FK_CRE_Clientes FOREIGN KEY (Id_Cliente)
	REFERENCES Clientes (Id_Cliente)
GO

ALTER TABLE Clientes_Reten_Exclusiones ADD CONSTRAINT FK_CRE_Reten_Tipos FOREIGN KEY (Id_Tipo_Reten)
	REFERENCES Cbtes_Reten_Tipos (Id_Tipo_Reten)
GO

